﻿;******************************************************************************
; 
; This AutoHotkey script defines Windows keyboard shortcuts for the Copy
; Settings > Copy Settings, Paste Settings, and Synchronize Settings commands.
; To enable the shortcuts:
; 
; 1.  Download and install AutoHotkey 2 (free).
; 
; 2. In Windows File Explorer, navigate to "copysettings.lrplugin" (the folder
;    containing this file).
; 
; 3. Double-click the file "Install-Keyboard-Shortcut.bat", which will copy
;    this file to your Startup folder.
; 
; 4. Restart your computer.
; 
; If you edit this file to change the shortcut, you'll need to repeat
; steps 3 and 4.
; 
; You may use any key combination for the shortcut, but beware that some are
; already appropriated by Windows and Lightroom.  Try the shortcut first to
; see if it already has a use.
; 
; To change the shortcut, change "^+c" below to whatever you want, using this
; syntax:
; 
; 	<1 or more modifiers><letter, digit, or punctuation>
; 
; where a modifier is one of:
; 
; 	^ 	Control
; 	!	Alt
; 	+	Shift
; 	#	Windows Logo 
; 
; For example, !a is ALT+A, and ^+3 is CTRL+SHIFT+3.  See the AutoHotKey
; documentation for the complete syntax of defining key combinations.
; 
;******************************************************************************

;******************************************************************************
;
; CHANGE THE KEY COMBINATIONS BELOW
;
; Change ^+c below to some other key combination. Be sure to end the line
; with "::".

; Copy Settings
^+c:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Copy Settings"
    Return
    }

; Paste Settings
^+v:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Paste Settings"
    Return
    }

; Synchronize Settings
^+s:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Synchronize Settings"
    Return
    }