--[[----------------------------------------------------------------------------
Available Gemini Models

This file lists the Gemini models available for use with Any Vision.

I try to update this within a few weeks of Google releasing new models. If
you edit this file to add newer Gemini models, there's a very good chance
they will work with the current version of Any Vision, but no guarantees --
Google is changing Gemini frequently.

Overview of Gemini models:
https://ai.google.dev/gemini-api/docs/models

Model rate limits:
https://ai.google.dev/gemini-api/docs/rate-limits

Model costs:
https://ai.google.dev/pricing
------------------------------------------------------------------------------]]

return {

{name = "default",
description = [[Use the default Gemini model specified in  Prompt > Advanced]],
cost = {input = 0.075 / 1e6, output = 0.30 / 1e6},
freeRequestsPerMin = 0},   

{name = "gemini-1.5-flash-8b",
description = [[Fast and cheap, with great performance for high-frequency,
    lower-intelligence tasks]],
hidden = true,
cost = {input = 0.0375 / 1e6, output = 0.15 / 1e6},
freeRequestsPerMin = 15},

{name = "gemini-1.5-pro",
description = [[Slower and more expensive, best performance for a wide variety 
    of reasoning tasks]],
hidden = true,
cost = {input = 1.250 / 1e6, output = 5.00 / 1e6},
freeRequestsPerMin = 2},

{name = "gemini-2.0-flash-exp",
hidden = true,
description = [[Gemini 2.0 experimental preview, subject to unannounced changes;
    free, rate-limited use only]],
cost = {input = 0.0 / 1e6, output = 0.0 / 1e6},
freeRequestsPerMin = 10},

{name = "gemini-2.0-flash",
description = [[Gemini 2.0 Flash model with next generation features and 
    improved capabilities]],
cost = {input = 0.10 / 1e6, output = 0.40 / 1e6},
freeRequestsPerMin = 15},

{name = "gemini-2.0-flash-lite-preview-02-05",
description = [[Gemini 2.0 Flash Lite Preview model optimized for cost 
    efficiency and low latency]],
hidden = true,
cost = {input = 0.075 / 1e6, output = 0.30 / 1e6},
freeRequestsPerMin = 30},

{name = "gemini-2.0-pro-exp-02-05",
hidden = true,
description = [[Gemini 2.0 Pro experimental preview, subject to unannounced 
    changes; free, rate-limited use only. Improved quality, especially for 
    world knowledge and code]],
hidden = true,
cost = {input = 0.0 / 1e6, output = 0.0 / 1e6},
freeRequestsPerMin = 2},

{name = "gemini-2.0-flash-thinking-exp-01-21",
hidden = true,
description = [[Gemini 2.0 Flash Thinking experimental preview, subject to 
    unannounced changes; free, rate-limited use only. Reasoning for complex 
    problems, new thinking capabilities]],
cost = {input = 0.0 / 1e6, output = 0.0 / 1e6},
freeRequestsPerMin = 10},

{name = "gemini-2.5-flash-preview-04-17",
hidden = true,
description = [[Gemini 2.5 Flash Preview, subject to unannounced
    changes. Best model in terms of price-performance, offering well-rounded 
    capabilities]],
cost = {input = 0.15 / 1e6, output = 0.60 / 1e6},
freeRequestsPerMin = 10},

{name = "gemini-2.5-flash-preview-05-20",
description = [[Gemini 2.5 Flash Preview, subject to unannounced
    changes. Best model in terms of price-performance, offering well-rounded 
    capabilities]],
hidden = true,
cost = {input = 0.15 / 1e6, output = 0.60 / 1e6},
freeRequestsPerMin = 10},

{name = "gemini-2.5-pro-preview-05-06",
hidden = true,
description = [[Gemini 2.5 Pro Preview, subject to unannounced changes;
    state-of-the-art thinking model, capable of reasoning over complex problems
    in code, math, and STEM]],
hidden = true,
cost = {input = 1.25 / 1e6, output = 10.00 / 1e6},
freeRequestsPerMin = 5},

{name = "gemini-2.5-pro-preview-06-05",
description = [[Gemini 2.5 Pro Preview, subject to unannounced changes;
    state-of-the-art thinking model, capable of reasoning over complex problems
    in code, math, and STEM]],
hidden = true,
cost = {input = 1.25 / 1e6, output = 10.00 / 1e6},
freeRequestsPerMin = 5},

{name = "gemini-2.5-flash-lite",
description = [[Gemini 2.5 Flash-Lite; most cost-efficient model supporting 
    high throughput]],
cost = {input = 0.10 / 1e6, output = 0.40 / 1e6},
freeRequestsPerMin = 15},

{name = "gemini-2.5-flash",
description = [[Gemini 2.5 Flash; adaptive thinking, cost efficiency]],
cost = {input = 0.30 / 1e6, output = 2.50 / 1e6},
freeRequestsPerMin = 10},

{name = "gemini-2.5-pro",
description = [[Gemini 2.5 Pro; enhanced thinking and reasoning, multimodal 
    understanding, advanced coding, and more]],
cost = {input = 1.25 / 1e6, output = 10.00 / 1e6},
freeRequestsPerMin = 5},

}

