--[[----------------------------------------------------------------------------
Copyright 2013 John R. Ellis.

If you want to disable a menu command, simply add "--" to the beginning of
the menu command's line below.

If you want to change the Windows ALT keyboard shortcut for a menu command,
edit the command name below and change the position of the "&".
------------------------------------------------------------------------------]]

local menuItems = {
    {title = "F&ind Folder or Collection", file = "Find.lua"},
    {title = "&Back to Previous Source/Filter/Selection", file = "Back.lua"},
    {title = "&Forward to Next Source/Filter/Selection", file = "Forward.lua"},
    {title = "&Next Folder/Collection", file = "Next.lua"},
    {title = "&Previous Folder/Collection", file = "Prev.lua"},
    {title = "&All Photographs", file = "All.lua"},
    {title = "&Quick Collection", file = "QuickCollection.lua"},
    {title = "Pre&vious Import", file = "PreviousImport.lua"},
    {title = "Added by Previous E&xport", file = "PreviousExport.lua"},
    {title = "First Photo", file = "FirstPhoto.lua"},
    {title = "Last Photo", file = "LastPhoto.lua"},
    {title = "Go to &Collection", file = "GoToCollection.lua"},
    {title = "S&ync Smart Collections", file = "SyncSmartCollections.lua"},
    {title = "&Toggle Syncing", file = "ToggleSyncing.lua"},
    {title = "P&ublish Collections", file = "Publish.lua"},
    {title = "List Folders", file = "ListFolders.lua"},
    {title = "List Collections", file = "ListCollections.lua"},
    {title = "Find &Missing Folders", file = "FindMissingFolders.lua"},
    {title = "Auto Stac&k", file = "AutoStack.lua"},
    {title = "Build Previews in Background", file = "BuildPreviewsCommand.lua"}}
    --{title = "D&ump Back/Forward Queue", file = "Dump.lua"}

return {
    LrSdkVersion = 6.0,
    LrSdkMinimumVersion = 6.0, 
    LrToolkitIdentifier = 'com.johnrellis.anysource',
    LrPluginName = "Any Source",
    LrPluginInfoUrl = "http://www.johnrellis.com/lightroom/anysource.htm",
    LrPluginInfoProvider = "PluginInfoProvider.lua",
    LrMetadataProvider = 'MetadataDefinition.lua',
    LrInitPlugin = 'InitPlugin.lua',
    LrShutdownPlugin = 'ShutdownPlugin.lua',
    LrLibraryMenuItems = menuItems,
    LrExportMenuItems = menuItems,
    VERSION = {major = 1, minor = 27, revision = 0, build = 0}}
    
    