﻿/******************************************************************************

This AutoHotkey script defines a Windows keyboard shortcut for the Any
Source commands.  To enable the shortcuts:

1.  Download and install AutoHotkey 2 (free).

2. In Windows File Explorer, navigate to "anysource.lrplugin" (the folder
   containing this file).

3. Double-click the file "Install-Keyboard-Shortcut.bat", which will copy
   this file to your Startup folder.

4. Restart your computer.

If you edit this file to change the shortcuts, you'll need to repeat
steps 3 and 4.

You may use any key combination for the shortcuts, but beware that some are
already appropriated by Windows and Lightroom.  Try the shortcut first to
see if it already has a use.

The shortcuts are defined below, with the key combination for each shortcut
preceding ":: {" on a line by itself.  Use this syntax for key combinations:

	<1 or more modifiers><letter, digit, or punctuation>::

where a modifier is one of:

	^ 	Control
	!	Alt
	+	Shift
	#	Windows Logo 

For example, !a is ALT+A, and ^+3 is CTRL+SHIFT+3.  See the AutoHotKey
documentation for the complete syntax of defining key combinations.

*******************************************************************************
*/

/******************************************************************************

Find Folder or Collection - ALT+L

*******************************************************************************
*/

!l:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Find Folder or Collection"
    Return
    }

/******************************************************************************

Previous Folder/Collection - ALT+P

*******************************************************************************
*/

!p:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Previous Folder/Collection"
    Return
    }

/******************************************************************************

Next Folder/Collection - ALT+N

*******************************************************************************
*/

!n:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Next Folder/Collection"
    Return
    }

/******************************************************************************

Back to Previous Source/Filter/Selection - ALT+B

*******************************************************************************
*/

!b:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Back to Previous Source/Filter/Selection"
    Return
    }

/******************************************************************************

Forward to Next Source/Filter/Selection - ALT+F

*******************************************************************************
*/

!f:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Forward to Next Source/Filter/Selection"
    Return
    }

/******************************************************************************

All Photographs - ALT+A

*******************************************************************************
*/

!a:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   All Photographs"
    Return
    }

/******************************************************************************

Quick Collection - ALT+Q

!q:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Quick Collection"
    Return
    }

/******************************************************************************

Previous Import - ALT+I

*******************************************************************************
*/

!i:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Previous Import"
    Return
    }

/******************************************************************************

Added by Previous Export - ALT+E

*******************************************************************************
*/

!e:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Added by Previous Export"
    Return
    }

/******************************************************************************

Go to Collection - ALT+T

*******************************************************************************
*/

!t:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Go to Collection"
    Return
    }

/******************************************************************************

Go to Folder in Library  - ALT+G

*******************************************************************************
*/

!g:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "Photo", "    Go to Folder in Library"
    Return
    }

/******************************************************************************

First Photo - CTRL-left-arrow

*******************************************************************************
*/

^Left:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   First Photo"
    Return
    }

/******************************************************************************

Last Photo - CTRL-right-arrow

*******************************************************************************
*/

^Right:: {
    SetTitleMatchMode 2 ; Substring match
    MenuSelect "Lightroom",, "File", "Plug-in Extras", "   Last Photo"
    Return
    }



