(******************************************************************************* 
usage: osascript get-menus.scpt

Extracts Lightroom Classic's menu-bar menu items to standard out. Each
line represents a menu item:

<indent> <vertical bar> <title>

where <indent> is n spaces representing the item's level n, 0 = top-level.
*******************************************************************************)

global s

on run argv

tell application "Lightroom Classic" 
    reopen 
    activate
    end 

tell application "System Events" to tell process "Lightroom Classic"
    set frontmost to true
    set s to ""
    set indent1 to "|"

    repeat with menuItem1 in (get menu bar item of menu bar 1)
        set s to s & indent1 & name of menuItem1 & "\n"

        set l2 to (get menu item of menu of menuItem1)
        if count of l2 > 0 then set l2 to item 1 of l2
        set indent2 to " " & indent1 
        repeat with menuItem2 in l2
            set s to s & indent2 & name of menuItem2 & "\n"

            set l3 to (get menu item of menu of menuItem2)
            if count of l3 > 0 then set l3 to item 1 of l3
            set indent3 to " " & indent2 
            repeat with menuItem3 in l3
                set s to s & indent3 & name of menuItem3 & "\n"

                set l4 to (get menu item of menu of menuItem3)
                if count of l4 > 0 then set l4 to item 1 of l4
                set indent4 to " " & indent3 
                repeat with menuItem4 in l4
                    set s to s & indent4 & name of menuItem4 & "\n"
                    end
                end
            end
        end

    return s
    end 

end 
